<?php

namespace WPDeskFIVendor\WPDesk\Library\FlexibleInvoicesCore\Configs;

class Currency
{
    const DEFAULT_SLUG = 'USD';
    /**
     * @return array
     */
    public static function get_currency_symbols() : array
    {
        /**
         * Filters currency symbols.
         *
         * @param array $symbols Symbols.
         *
         * @return array
         *
         * @since 3.0.0
         */
        return (array) \apply_filters('fi/core/currency/symbols', ['AED' => '&#x62f;.&#x625;', 'AFN' => '&#x60b;', 'ALL' => 'L', 'AMD' => 'AMD', 'ANG' => '&fnof;', 'AOA' => 'Kz', 'ARS' => '&#36;', 'AUD' => '&#36;', 'AWG' => 'Afl.', 'AZN' => 'AZN', 'BAM' => 'KM', 'BBD' => '&#36;', 'BDT' => '&#2547;&nbsp;', 'BGN' => '&#1083;&#1074;.', 'BHD' => '.&#x62f;.&#x628;', 'BIF' => 'Fr', 'BMD' => '&#36;', 'BND' => '&#36;', 'BOB' => 'Bs.', 'BRL' => '&#82;&#36;', 'BSD' => '&#36;', 'BTC' => '&#3647;', 'BTN' => 'Nu.', 'BWP' => 'P', 'BYR' => 'Br', 'BZD' => '&#36;', 'CAD' => '&#36;', 'CDF' => 'Fr', 'CHF' => '&#67;&#72;&#70;', 'CLP' => '&#36;', 'CNY' => '&yen;', 'COP' => '&#36;', 'CRC' => '&#x20a1;', 'CUC' => '&#36;', 'CUP' => '&#36;', 'CVE' => '&#36;', 'CZK' => '&#75;&#269;', 'DJF' => 'Fr', 'DKK' => 'DKK', 'DOP' => 'RD&#36;', 'DZD' => '&#x62f;.&#x62c;', 'EGP' => 'EGP', 'ERN' => 'Nfk', 'ETB' => 'Br', 'EUR' => '&euro;', 'FJD' => '&#36;', 'FKP' => '&pound;', 'GBP' => '&pound;', 'GEL' => '&#x10da;', 'GGP' => '&pound;', 'GHS' => '&#x20b5;', 'GIP' => '&pound;', 'GMD' => 'D', 'GNF' => 'Fr', 'GTQ' => 'Q', 'GYD' => '&#36;', 'HKD' => '&#36;', 'HNL' => 'L', 'HRK' => 'Kn', 'HTG' => 'G', 'HUF' => '&#70;&#116;', 'IDR' => 'Rp', 'ILS' => '&#8362;', 'IMP' => '&pound;', 'INR' => '&#8377;', 'IQD' => '&#x639;.&#x62f;', 'IRR' => '&#xfdfc;', 'IRT' => '&#x062A;&#x0648;&#x0645;&#x0627;&#x0646;', 'ISK' => 'kr.', 'JEP' => '&pound;', 'JMD' => '&#36;', 'JOD' => '&#x62f;.&#x627;', 'JPY' => '&yen;', 'KES' => 'KSh', 'KGS' => '&#x441;&#x43e;&#x43c;', 'KHR' => '&#x17db;', 'KMF' => 'Fr', 'KPW' => '&#x20a9;', 'KRW' => '&#8361;', 'KWD' => '&#x62f;.&#x643;', 'KYD' => '&#36;', 'KZT' => 'KZT', 'LAK' => '&#8365;', 'LBP' => '&#x644;.&#x644;', 'LKR' => '&#xdbb;&#xdd4;', 'LRD' => '&#36;', 'LSL' => 'L', 'LYD' => '&#x644;.&#x62f;', 'MAD' => '&#x62f;.&#x645;.', 'MDL' => 'MDL', 'MGA' => 'Ar', 'MKD' => '&#x434;&#x435;&#x43d;', 'MMK' => 'Ks', 'MNT' => '&#x20ae;', 'MOP' => 'P', 'MRO' => 'UM', 'MUR' => '&#x20a8;', 'MVR' => '.&#x783;', 'MWK' => 'MK', 'MXN' => '&#36;', 'MYR' => '&#82;&#77;', 'MZN' => 'MT', 'NAD' => '&#36;', 'NGN' => '&#8358;', 'NIO' => 'C&#36;', 'NOK' => '&#107;&#114;', 'NPR' => '&#8360;', 'NZD' => '&#36;', 'OMR' => '&#x631;.&#x639;.', 'PAB' => 'B/.', 'PEN' => 'S/.', 'PGK' => 'K', 'PHP' => '&#8369;', 'PKR' => '&#8360;', 'PLN' => '&#122;&#322;', 'PRB' => '&#x440;.', 'PYG' => '&#8370;', 'QAR' => '&#x631;.&#x642;', 'RMB' => '&yen;', 'RON' => 'lei', 'RSD' => '&#x434;&#x438;&#x43d;.', 'RUB' => '&#8381;', 'RWF' => 'Fr', 'SAR' => '&#x631;.&#x633;', 'SBD' => '&#36;', 'SCR' => '&#x20a8;', 'SDG' => '&#x62c;.&#x633;.', 'SEK' => '&#107;&#114;', 'SGD' => '&#36;', 'SHP' => '&pound;', 'SLL' => 'Le', 'SOS' => 'Sh', 'SRD' => '&#36;', 'SSP' => '&pound;', 'STD' => 'Db', 'SYP' => '&#x644;.&#x633;', 'SZL' => 'L', 'THB' => '&#3647;', 'TJS' => '&#x405;&#x41c;', 'TMT' => 'm', 'TND' => '&#x62f;.&#x62a;', 'TOP' => 'T&#36;', 'TRY' => '&#8378;', 'TTD' => '&#36;', 'TWD' => '&#78;&#84;&#36;', 'TZS' => 'Sh', 'UAH' => '&#8372;', 'UGX' => 'UGX', 'USD' => '&#36;', 'UYU' => '&#36;', 'UZS' => 'UZS', 'VEF' => 'Bs F', 'VND' => '&#8363;', 'VUV' => 'Vt', 'WST' => 'T', 'XAF' => 'Fr', 'XCD' => '&#36;', 'XOF' => 'Fr', 'XPF' => 'Fr', 'YER' => '&#xfdfc;', 'ZAR' => '&#82;', 'ZMW' => 'ZK']);
    }
    /**
     * @param string $currency
     *
     * @return mixed
     */
    public static function get_currency_symbol(string $currency)
    {
        $symbols = self::get_currency_symbols();
        return $symbols[$currency] ?? $currency;
    }
    /**
     * @return array
     */
    public static function get_currencies_options() : array
    {
        $currencies = ['AED' => \esc_html__('United Arab Emirates dirham', 'flexible-invoices'), 'AFN' => \esc_html__('Afghan afghani', 'flexible-invoices'), 'ALL' => \esc_html__('Albanian lek', 'flexible-invoices'), 'AMD' => \esc_html__('Armenian dram', 'flexible-invoices'), 'ANG' => \esc_html__('Netherlands Antillean guilder', 'flexible-invoices'), 'AOA' => \esc_html__('Angolan kwanza', 'flexible-invoices'), 'ARS' => \esc_html__('Argentine peso', 'flexible-invoices'), 'AUD' => \esc_html__('Australian dollar', 'flexible-invoices'), 'AWG' => \esc_html__('Aruban florin', 'flexible-invoices'), 'AZN' => \esc_html__('Azerbaijani manat', 'flexible-invoices'), 'BAM' => \esc_html__('Bosnia and Herzegovina convertible mark', 'flexible-invoices'), 'BBD' => \esc_html__('Barbadian dollar', 'flexible-invoices'), 'BDT' => \esc_html__('Bangladeshi taka', 'flexible-invoices'), 'BGN' => \esc_html__('Bulgarian lev', 'flexible-invoices'), 'BHD' => \esc_html__('Bahraini dinar', 'flexible-invoices'), 'BIF' => \esc_html__('Burundian franc', 'flexible-invoices'), 'BMD' => \esc_html__('Bermudian dollar', 'flexible-invoices'), 'BND' => \esc_html__('Brunei dollar', 'flexible-invoices'), 'BOB' => \esc_html__('Bolivian boliviano', 'flexible-invoices'), 'BRL' => \esc_html__('Brazilian real', 'flexible-invoices'), 'BSD' => \esc_html__('Bahamian dollar', 'flexible-invoices'), 'BTC' => \esc_html__('Bitcoin', 'flexible-invoices'), 'BTN' => \esc_html__('Bhutanese ngultrum', 'flexible-invoices'), 'BWP' => \esc_html__('Botswana pula', 'flexible-invoices'), 'BYR' => \esc_html__('Belarusian ruble', 'flexible-invoices'), 'BZD' => \esc_html__('Belize dollar', 'flexible-invoices'), 'CAD' => \esc_html__('Canadian dollar', 'flexible-invoices'), 'CDF' => \esc_html__('Congolese franc', 'flexible-invoices'), 'CHF' => \esc_html__('Swiss franc', 'flexible-invoices'), 'CLP' => \esc_html__('Chilean peso', 'flexible-invoices'), 'CNY' => \esc_html__('Chinese yuan', 'flexible-invoices'), 'COP' => \esc_html__('Colombian peso', 'flexible-invoices'), 'CRC' => \esc_html__('Costa Rican col&oacute;n', 'flexible-invoices'), 'CUC' => \esc_html__('Cuban convertible peso', 'flexible-invoices'), 'CUP' => \esc_html__('Cuban peso', 'flexible-invoices'), 'CVE' => \esc_html__('Cape Verdean escudo', 'flexible-invoices'), 'CZK' => \esc_html__('Czech koruna', 'flexible-invoices'), 'DJF' => \esc_html__('Djiboutian franc', 'flexible-invoices'), 'DKK' => \esc_html__('Danish krone', 'flexible-invoices'), 'DOP' => \esc_html__('Dominican peso', 'flexible-invoices'), 'DZD' => \esc_html__('Algerian dinar', 'flexible-invoices'), 'EGP' => \esc_html__('Egyptian pound', 'flexible-invoices'), 'ERN' => \esc_html__('Eritrean nakfa', 'flexible-invoices'), 'ETB' => \esc_html__('Ethiopian birr', 'flexible-invoices'), 'EUR' => \esc_html__('Euro', 'flexible-invoices'), 'FJD' => \esc_html__('Fijian dollar', 'flexible-invoices'), 'FKP' => \esc_html__('Falkland Islands pound', 'flexible-invoices'), 'GBP' => \esc_html__('Pound sterling', 'flexible-invoices'), 'GEL' => \esc_html__('Georgian lari', 'flexible-invoices'), 'GGP' => \esc_html__('Guernsey pound', 'flexible-invoices'), 'GHS' => \esc_html__('Ghana cedi', 'flexible-invoices'), 'GIP' => \esc_html__('Gibraltar pound', 'flexible-invoices'), 'GMD' => \esc_html__('Gambian dalasi', 'flexible-invoices'), 'GNF' => \esc_html__('Guinean franc', 'flexible-invoices'), 'GTQ' => \esc_html__('Guatemalan quetzal', 'flexible-invoices'), 'GYD' => \esc_html__('Guyanese dollar', 'flexible-invoices'), 'HKD' => \esc_html__('Hong Kong dollar', 'flexible-invoices'), 'HNL' => \esc_html__('Honduran lempira', 'flexible-invoices'), 'HRK' => \esc_html__('Croatian kuna', 'flexible-invoices'), 'HTG' => \esc_html__('Haitian gourde', 'flexible-invoices'), 'HUF' => \esc_html__('Hungarian forint', 'flexible-invoices'), 'IDR' => \esc_html__('Indonesian rupiah', 'flexible-invoices'), 'ILS' => \esc_html__('Israeli new shekel', 'flexible-invoices'), 'IMP' => \esc_html__('Manx pound', 'flexible-invoices'), 'INR' => \esc_html__('Indian rupee', 'flexible-invoices'), 'IQD' => \esc_html__('Iraqi dinar', 'flexible-invoices'), 'IRR' => \esc_html__('Iranian rial', 'flexible-invoices'), 'ISK' => \esc_html__('Icelandic kr&oacute;na', 'flexible-invoices'), 'JEP' => \esc_html__('Jersey pound', 'flexible-invoices'), 'JMD' => \esc_html__('Jamaican dollar', 'flexible-invoices'), 'JOD' => \esc_html__('Jordanian dinar', 'flexible-invoices'), 'JPY' => \esc_html__('Japanese yen', 'flexible-invoices'), 'KES' => \esc_html__('Kenyan shilling', 'flexible-invoices'), 'KGS' => \esc_html__('Kyrgyzstani som', 'flexible-invoices'), 'KHR' => \esc_html__('Cambodian riel', 'flexible-invoices'), 'KMF' => \esc_html__('Comorian franc', 'flexible-invoices'), 'KPW' => \esc_html__('North Korean won', 'flexible-invoices'), 'KRW' => \esc_html__('South Korean won', 'flexible-invoices'), 'KWD' => \esc_html__('Kuwaiti dinar', 'flexible-invoices'), 'KYD' => \esc_html__('Cayman Islands dollar', 'flexible-invoices'), 'KZT' => \esc_html__('Kazakhstani tenge', 'flexible-invoices'), 'LAK' => \esc_html__('Lao kip', 'flexible-invoices'), 'LBP' => \esc_html__('Lebanese pound', 'flexible-invoices'), 'LKR' => \esc_html__('Sri Lankan rupee', 'flexible-invoices'), 'LRD' => \esc_html__('Liberian dollar', 'flexible-invoices'), 'LSL' => \esc_html__('Lesotho loti', 'flexible-invoices'), 'LYD' => \esc_html__('Libyan dinar', 'flexible-invoices'), 'MAD' => \esc_html__('Moroccan dirham', 'flexible-invoices'), 'MDL' => \esc_html__('Moldovan leu', 'flexible-invoices'), 'MGA' => \esc_html__('Malagasy ariary', 'flexible-invoices'), 'MKD' => \esc_html__('Macedonian denar', 'flexible-invoices'), 'MMK' => \esc_html__('Burmese kyat', 'flexible-invoices'), 'MNT' => \esc_html__('Mongolian t&ouml;gr&ouml;g', 'flexible-invoices'), 'MOP' => \esc_html__('Macanese pataca', 'flexible-invoices'), 'MRO' => \esc_html__('Mauritanian ouguiya', 'flexible-invoices'), 'MUR' => \esc_html__('Mauritian rupee', 'flexible-invoices'), 'MVR' => \esc_html__('Maldivian rufiyaa', 'flexible-invoices'), 'MWK' => \esc_html__('Malawian kwacha', 'flexible-invoices'), 'MXN' => \esc_html__('Mexican peso', 'flexible-invoices'), 'MYR' => \esc_html__('Malaysian ringgit', 'flexible-invoices'), 'MZN' => \esc_html__('Mozambican metical', 'flexible-invoices'), 'NAD' => \esc_html__('Namibian dollar', 'flexible-invoices'), 'NGN' => \esc_html__('Nigerian naira', 'flexible-invoices'), 'NIO' => \esc_html__('Nicaraguan c&oacute;rdoba', 'flexible-invoices'), 'NOK' => \esc_html__('Norwegian krone', 'flexible-invoices'), 'NPR' => \esc_html__('Nepalese rupee', 'flexible-invoices'), 'NZD' => \esc_html__('New Zealand dollar', 'flexible-invoices'), 'OMR' => \esc_html__('Omani rial', 'flexible-invoices'), 'PAB' => \esc_html__('Panamanian balboa', 'flexible-invoices'), 'PEN' => \esc_html__('Peruvian nuevo sol', 'flexible-invoices'), 'PGK' => \esc_html__('Papua New Guinean kina', 'flexible-invoices'), 'PHP' => \esc_html__('Philippine peso', 'flexible-invoices'), 'PKR' => \esc_html__('Pakistani rupee', 'flexible-invoices'), 'PLN' => \esc_html__('Polish z&#x142;oty', 'flexible-invoices'), 'PRB' => \esc_html__('Transnistrian ruble', 'flexible-invoices'), 'PYG' => \esc_html__('Paraguayan guaran&iacute;', 'flexible-invoices'), 'QAR' => \esc_html__('Qatari riyal', 'flexible-invoices'), 'RON' => \esc_html__('Romanian leu', 'flexible-invoices'), 'RSD' => \esc_html__('Serbian dinar', 'flexible-invoices'), 'RUB' => \esc_html__('Russian ruble', 'flexible-invoices'), 'RWF' => \esc_html__('Rwandan franc', 'flexible-invoices'), 'SAR' => \esc_html__('Saudi riyal', 'flexible-invoices'), 'SBD' => \esc_html__('Solomon Islands dollar', 'flexible-invoices'), 'SCR' => \esc_html__('Seychellois rupee', 'flexible-invoices'), 'SDG' => \esc_html__('Sudanese pound', 'flexible-invoices'), 'SEK' => \esc_html__('Swedish krona', 'flexible-invoices'), 'SGD' => \esc_html__('Singapore dollar', 'flexible-invoices'), 'SHP' => \esc_html__('Saint Helena pound', 'flexible-invoices'), 'SLL' => \esc_html__('Sierra Leonean leone', 'flexible-invoices'), 'SOS' => \esc_html__('Somali shilling', 'flexible-invoices'), 'SRD' => \esc_html__('Surinamese dollar', 'flexible-invoices'), 'SSP' => \esc_html__('South Sudanese pound', 'flexible-invoices'), 'STD' => \esc_html__('S&atilde;o Tom&eacute; and Pr&iacute;ncipe dobra', 'flexible-invoices'), 'SYP' => \esc_html__('Syrian pound', 'flexible-invoices'), 'SZL' => \esc_html__('Swazi lilangeni', 'flexible-invoices'), 'THB' => \esc_html__('Thai baht', 'flexible-invoices'), 'TJS' => \esc_html__('Tajikistani somoni', 'flexible-invoices'), 'TMT' => \esc_html__('Turkmenistan manat', 'flexible-invoices'), 'TND' => \esc_html__('Tunisian dinar', 'flexible-invoices'), 'TOP' => \esc_html__('Tongan pa&#x2bb;anga', 'flexible-invoices'), 'TRY' => \esc_html__('Turkish lira', 'flexible-invoices'), 'TTD' => \esc_html__('Trinidad and Tobago dollar', 'flexible-invoices'), 'TWD' => \esc_html__('New Taiwan dollar', 'flexible-invoices'), 'TZS' => \esc_html__('Tanzanian shilling', 'flexible-invoices'), 'UAH' => \esc_html__('Ukrainian hryvnia', 'flexible-invoices'), 'UGX' => \esc_html__('Ugandan shilling', 'flexible-invoices'), 'USD' => \esc_html__('United States dollar', 'flexible-invoices'), 'UYU' => \esc_html__('Uruguayan peso', 'flexible-invoices'), 'UZS' => \esc_html__('Uzbekistani som', 'flexible-invoices'), 'VEF' => \esc_html__('Venezuelan bol&iacute;var', 'flexible-invoices'), 'VND' => \esc_html__('Vietnamese &#x111;&#x1ed3;ng', 'flexible-invoices'), 'VUV' => \esc_html__('Vanuatu vatu', 'flexible-invoices'), 'WST' => \esc_html__('Samoan t&#x101;l&#x101;', 'flexible-invoices'), 'XAF' => \esc_html__('Central African CFA franc', 'flexible-invoices'), 'XCD' => \esc_html__('East Caribbean dollar', 'flexible-invoices'), 'XOF' => \esc_html__('West African CFA franc', 'flexible-invoices'), 'XPF' => \esc_html__('CFP franc', 'flexible-invoices'), 'YER' => \esc_html__('Yemeni rial', 'flexible-invoices'), 'ZAR' => \esc_html__('South African rand', 'flexible-invoices'), 'ZMW' => \esc_html__('Zambian kwacha', 'flexible-invoices')];
        /**
         * Filters currencies.
         *
         * @param array $currencies Currencies.
         *
         * @return array
         *
         * @since 3.0.0
         */
        $currencies = \apply_filters('fi/core/currency/currencies', $currencies);
        return \array_unique($currencies);
    }
    /**
     * @return array
     */
    public static function get_currency_position_options($country_slug = self::DEFAULT_SLUG) : array
    {
        $options = [];
        $currencies_options = self::get_currencies_options();
        foreach ($currencies_options as $currency_slug => $currency_name) {
            $symbol = self::get_currency_symbol($currency_slug);
            $options[$currency_slug] = ['left' => \sprintf(\esc_html__('Left (%s99.99)', 'flexible-invoices-woocommerce'), $symbol), 'right' => \sprintf(\esc_html__('Right (99.99%s)', 'flexible-invoices-woocommerce'), $symbol), 'left_space' => \sprintf(\esc_html__('Left with space (%s 99.99)', 'flexible-invoices-woocommerce'), $symbol), 'right_space' => \sprintf(\esc_html__('Right with space (99.99 %s)', 'flexible-invoices-woocommerce'), $symbol)];
        }
        return $options[$country_slug] ?? $options[self::DEFAULT_SLUG];
    }
}
